# Topological sort
## Medium
<div class="problems_problem_content__Xm_eO"><p><span style="font-size:18px">Given a Directed Acyclic Graph (DAG) with V vertices and E edges, Find any Topological Sorting of that Graph.</span></p>

<p><br>
<span style="font-size:18px"><strong>Example 1:</strong></span></p>

<pre><span style="font-size:18px"><strong>Input:</strong></span>
<img alt="" src="data:image/png;base64,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">
<span style="font-size:18px"><strong>Output:</strong>
1
<strong>Explanation</strong>:
The output 1 denotes that the order is
valid. So, if you have, implemented
your function correctly, then output
would be 1 for all test cases.</span>
<span style="font-size:18px">One possible Topological order for the
graph is 3, 2, 1, 0.</span>
</pre>

<p><span style="font-size:18px"><strong>Example 2:</strong></span></p>

<pre><span style="font-size:18px"><strong>Input:</strong></span>
<img alt="" src="data:image/png;base64,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">
<span style="font-size:18px"><strong>Output:</strong>
1
</span><span style="font-size:18px"><strong>Explanation:
</strong></span><span style="font-size:18px">The output 1 denotes that the order is
valid. So, if you have, implemented
your function correctly, then output
would be 1 for all test cases.
One possible Topological order for the
graph is 5, 4, 2, 1, 3, 0.</span></pre>

<p><br>
<span style="font-size:18px"><strong>Your Task:</strong><br>
You don't need to read input or print anything. Your task is to complete the function&nbsp;<strong>topoSort()</strong>&nbsp;</span> <span style="font-size:18px">which takes the integer V denoting the number of vertices and adjacency list as input parameters</span> <span style="font-size:18px"> and returns an array consisting of a the vertices in Topological order. As there are multiple Topological orders possible, you may return any of them. If your returned topo sort is correct then console output will be 1 else 0.</span></p>

<p><br>
<span style="font-size:18px"><strong>Expected Time Complexity:</strong>&nbsp;O(V + E).<br>
<strong>Expected Auxiliary Space:</strong>&nbsp;O(V).</span></p>

<p><br>
<span style="font-size:18px"><strong>Constraints:</strong><br>
2 </span> <span style="font-size:18px">≤</span> <span style="font-size:18px"> V </span> <span style="font-size:18px">≤</span> <span style="font-size:18px">10<sup>4</sup><br>
1 </span> <span style="font-size:18px">≤</span> <span style="font-size:18px"> E </span> <span style="font-size:18px">≤</span> <span style="font-size:18px"> (N*(N-1))/2</span></p>
</div>